/*****************************************************************************************
* MERGING INDIVIDUAL FILES ACROSS WAVES INTO LONG FORMAT                                 *
*****************************************************************************************/

clear 

// SET WORKING DIRECTORY 

cd "/Users/amwaj-opto/Desktop/COVI19 "

//loop through each wave
foreach w in a b c d e f g h i { 
	
	// find the wave number
	local waveno=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
	
	// open the individual level file
	use pidp c`w'_age using "c`w'_indresp_w", clear
	
	
	// drop the wave prefix from all variables
	rename c`w'_* *
	
	// create a wave variable
	gen wave=`waveno'
	
	// save one file for each wave
	save tempc`w', replace
}

// open the file for the first wave (wave a_)
use tempca , clear

// loop through the remaining waves
foreach w in  b c d e f g h i {

	// append the files for the second wave onwards
	append using tempc`w'
}
